﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;

namespace BMS.Web.Models
{
    /// <summary>
    /// The Model class for the national and regional pages.
    /// </summary>
    public class NationalAndRegionalViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the visibility controls for current user.
        /// </summary>
        /// <value>
        /// The visibility controls for current user.
        /// </value>
        public string VisibilityControlsForCurrentUser { get; set; }

        /// <summary>
        /// Gets or sets the name of the user.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        public User CurrentUser { get; set; }

        /// <summary>
        /// Gets or sets the regions and visns.
        /// </summary>
        /// <value>
        /// The regions and visns.
        /// </value>
        public Dictionary<Region, List<VisnItemModel>> RegionsAndVisns { get; set; }
        /// <summary>
        /// Gets or sets the regions.
        /// </summary>
        /// <value>
        /// The regions.
        /// </value>
        public List<RegionModel> Regions { get; set; }

        /// <summary>
        /// Gets or sets the selected region extension.
        /// </summary>
        /// <value>
        /// The selected region extension.
        /// </value>
        public string SelectedRegionExtension { get; set; }

        /// <summary>
        /// Gets or sets the selected visn extension.
        /// </summary>
        /// <value>
        /// The selected visn extension.
        /// </value>
        public string SelectedVisnExtension { get; set; }

        /// <summary>
        /// Gets or sets the visns.
        /// </summary>
        /// <value>
        /// The visns.
        /// </value>
        public List<VisnModel> Visns { get; set; }

        /// <summary>
        /// Gets or sets the specialities.
        /// </summary>
        /// <value>
        /// The specialities.
        /// </value>
        public List<CD> Specialities { get; set; }

        /// <summary>
        /// Gets or sets the selected speciality.
        /// </summary>
        /// <value>
        /// The selected speciality.
        /// </value>
        public CD SelectedSpeciality { get; set; }

        /// <summary>
        /// Gets or sets the waiting time list.
        /// </summary>
        /// <value>
        /// The waiting time list.
        /// </value>
        public CDList WaitingTimes { get; set; }

        /// <summary>
        /// Gets or sets the selected waiting time.
        /// </summary>
        /// <value>
        /// The selected waiting time.
        /// </value>
        public CD SelectedWaitingTime { get; set; }

        /// <summary>
        /// Gets or sets the waiting views.
        /// </summary>
        /// <value>
        /// The waiting views.
        /// </value>
        public CDList WaitingViews { get; set; }

        /// <summary>
        /// Gets or sets the display national patients list.
        /// </summary>
        /// <value>
        /// The display national patients list.
        /// </value>
        public IList<string> DisplayNationalPatientsList { get; set; }

        /// <summary>
        /// Gets or sets the selected national patient.
        /// </summary>
        /// <value>
        /// The selected national patient.
        /// </value>
        public string SelectedNationalPatient { get; set; }

        /// <summary>
        /// Gets or sets the waiting view.
        /// </summary>
        /// <value>
        /// The waiting view.
        /// </value>
        public CD SelectedWaitingView { get; set; }

        /// <summary>
        /// Gets or sets the fill visns by region.
        /// </summary>
        /// <value>
        /// The fill visns by region.
        /// </value>
        public string FillVisnsByRegion { get; set; }

        /// <summary>
        /// Gets or sets the filter operation.
        /// </summary>
        /// <value>
        /// The filter operation.
        /// </value>
        public string FilterOperation { get; set; }

        /// <summary>
        /// Gets or sets the default II.
        /// </summary>
        /// <value>
        /// The default II.
        /// </value>
        public II DefaultII { get; set; }

        /// <summary>
        /// Gets or sets the standard patient waiting.
        /// </summary>
        /// <value>
        /// The standard patient waiting.
        /// </value>
        public IList<TransferInfo> StandardPatientWaiting { get; set; }

        /// <summary>
        /// Gets or sets the data view patient waiting.
        /// </summary>
        /// <value>
        /// The data view patient waiting.
        /// </value>
        public IList<DateView> DataViewPatientWaiting { get; set; }

        /// <summary>
        /// Gets or sets the national bed availability report URL.
        /// </summary>
        /// <value>
        /// The national bed availability report URL.
        /// </value>
        public string NationalBedAvailabilityReportUrl { get; set; }

        /// <summary>
        /// Gets or sets the th colspan count.
        /// </summary>
        /// <value>
        /// The th colspan count.
        /// </value>
        public int ThColspanCount { get; set; }

    }

    public class RegionModel
    {
        public II Id { get; set; }
        public string Name { get; set; }
    }

    public class VisnModel
    {
        public II Id { get; set; }
        public string Name { get; set; }
    }

    public class VisnItemModel
    {
        public Visn Visn { get; set; }
        public int LoggedUsers { get; set; }
    }
}